<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager\Resource;

use Google\Site_Kit_Dependencies\Google\Service\TagManager\ListTriggersResponse;
use Google\Site_Kit_Dependencies\Google\Service\TagManager\RevertTriggerResponse;
use Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger;
/**
 * The "triggers" collection of methods.
 * Typical usage is:
 *  <code>
 *   $tagmanagerService = new Google\Service\TagManager(...);
 *   $triggers = $tagmanagerService->accounts_containers_workspaces_triggers;
 *  </code>
 */
class AccountsContainersWorkspacesTriggers extends \Google\Site_Kit_Dependencies\Google\Service\Resource
{
    /**
     * Creates a GTM Trigger. (triggers.create)
     *
     * @param string $parent GTM Workspace's API relative path. Example:
     * accounts/{account_id}/containers/{container_id}/workspaces/{workspace_id}
     * @param Trigger $postBody
     * @param array $optParams Optional parameters.
     * @return Trigger
     * @throws \Google\Service\Exception
     */
    public function create($parent, \Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger $postBody, $optParams = [])
    {
        $params = ['parent' => $parent, 'postBody' => $postBody];
        $params = \array_merge($params, $optParams);
        return $this->call('create', [$params], \Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger::class);
    }
    /**
     * Deletes a GTM Trigger. (triggers.delete)
     *
     * @param string $path GTM Trigger's API relative path. Example: accounts/{accou
     * nt_id}/containers/{container_id}/workspaces/{workspace_id}/triggers/{trigger_
     * id}
     * @param array $optParams Optional parameters.
     * @throws \Google\Service\Exception
     */
    public function delete($path, $optParams = [])
    {
        $params = ['path' => $path];
        $params = \array_merge($params, $optParams);
        return $this->call('delete', [$params]);
    }
    /**
     * Gets a GTM Trigger. (triggers.get)
     *
     * @param string $path GTM Trigger's API relative path. Example: accounts/{accou
     * nt_id}/containers/{container_id}/workspaces/{workspace_id}/triggers/{trigger_
     * id}
     * @param array $optParams Optional parameters.
     * @return Trigger
     * @throws \Google\Service\Exception
     */
    public function get($path, $optParams = [])
    {
        $params = ['path' => $path];
        $params = \array_merge($params, $optParams);
        return $this->call('get', [$params], \Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger::class);
    }
    /**
     * Lists all GTM Triggers of a Container.
     * (triggers.listAccountsContainersWorkspacesTriggers)
     *
     * @param string $parent GTM Workspace's API relative path. Example:
     * accounts/{account_id}/containers/{container_id}/workspaces/{workspace_id}
     * @param array $optParams Optional parameters.
     *
     * @opt_param string pageToken Continuation token for fetching the next page of
     * results.
     * @return ListTriggersResponse
     * @throws \Google\Service\Exception
     */
    public function listAccountsContainersWorkspacesTriggers($parent, $optParams = [])
    {
        $params = ['parent' => $parent];
        $params = \array_merge($params, $optParams);
        return $this->call('list', [$params], \Google\Site_Kit_Dependencies\Google\Service\TagManager\ListTriggersResponse::class);
    }
    /**
     * Reverts changes to a GTM Trigger in a GTM Workspace. (triggers.revert)
     *
     * @param string $path GTM Trigger's API relative path. Example: accounts/{accou
     * nt_id}/containers/{container_id}/workspaces/{workspace_id}/triggers/{trigger_
     * id}
     * @param array $optParams Optional parameters.
     *
     * @opt_param string fingerprint When provided, this fingerprint must match the
     * fingerprint of the trigger in storage.
     * @return RevertTriggerResponse
     * @throws \Google\Service\Exception
     */
    public function revert($path, $optParams = [])
    {
        $params = ['path' => $path];
        $params = \array_merge($params, $optParams);
        return $this->call('revert', [$params], \Google\Site_Kit_Dependencies\Google\Service\TagManager\RevertTriggerResponse::class);
    }
    /**
     * Updates a GTM Trigger. (triggers.update)
     *
     * @param string $path GTM Trigger's API relative path. Example: accounts/{accou
     * nt_id}/containers/{container_id}/workspaces/{workspace_id}/triggers/{trigger_
     * id}
     * @param Trigger $postBody
     * @param array $optParams Optional parameters.
     *
     * @opt_param string fingerprint When provided, this fingerprint must match the
     * fingerprint of the trigger in storage.
     * @return Trigger
     * @throws \Google\Service\Exception
     */
    public function update($path, \Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger $postBody, $optParams = [])
    {
        $params = ['path' => $path, 'postBody' => $postBody];
        $params = \array_merge($params, $optParams);
        return $this->call('update', [$params], \Google\Site_Kit_Dependencies\Google\Service\TagManager\Trigger::class);
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\Resource\AccountsContainersWorkspacesTriggers::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_Resource_AccountsContainersWorkspacesTriggers');
