jQuery(document).ready(function() {

    jQuery('.rss-tooltip').tooltipster({
        'position': 'top-left',
        'theme': 'rss-tooltip-theme'
    });

    // Toggle content for metaboxes
    jQuery('.hndle, .handlediv').click(function() {
        jQuery(this).parent().toggleClass('closed');
        if (jQuery(this).parent().hasClass('closed')) {

        }
    });

    jQuery('.rssap-meta-box-container').hide();


    function loadPreview()
    {
        var url = jQuery('#rssap-load-preview-url').val();
        jQuery('#rssap-preview').show();
        jQuery('#rssap-preview .inside').empty().addClass('loading');
        jQuery.post(url, jQuery('#rssap-add-source-form').serialize(), function(data) {
            jQuery('#rssap-preview .inside').html(data).removeClass('loading');
        });
    }

    jQuery('.feed-preview-btn').click(function() {
        loadPreview();
        return false;
    });

    jQuery('#rssap-add-source-form').submit(function() {
        jQuery.post(
            jQuery(this).attr('action'),
            jQuery(this).serialize(),
            function(data) {
                if (data.status) {
                    window.location = data.redirect_url;
                } else {
                    displayErrors(data.errors);
                }
            },
            'json'
        );
        return false;
    });

    function displayErrors(errors)
    {
        if (!errors) return;
        var offsetTop = 0;
        jQuery.each(errors, function(name, error) {
            var elements = jQuery.find('[name="'+name+'"]');
            if (elements.length) {
                jQuery('[name="'+name+'"]').last().parents('.rssap-field-container').first().append('<p class="rssap-error-notice">'+error+'</p>');
                if (!offsetTop) {
                    offsetTop = jQuery('[name="'+name+'"]').last().parents('.rssap-field-container').first().offset().top;
                }
            }
        });
        if (offsetTop) {
            jQuery(window).scrollTop(offsetTop);
        }
    }

    function clearErrors()
    {
        jQuery('.rssap-error-notice').remove();
    }

    if (jQuery('#rssap-add-source-form').hasClass('edit')) {
        loadPreview();
    }

    jQuery('#content-extractor-btn').fancybox({
        beforeLoad: function() {
            jQuery('#content-extractor-iframe').attr('src', jQuery('#rssap-content-extractor-url').val()+'&feedUrl='+Base64.encode(jQuery('#rssap-url').val()));
            jQuery.fancybox.update();
        },
        'onClosed' : function() {
            jQuery("#content-extractor").hide();
        }
    });

    jQuery('#rssap-enable-scrapper').change(function() {
        if (jQuery(this).is(':checked')) {
            jQuery('.content-extractor-options').show();
        } else {
            jQuery('.content-extractor-options').hide();
        }
    });

    jQuery('#rssap-enable-filters').change(function() {
        if (jQuery(this).is(':checked')) {
            jQuery('.content-filter-options').show();
        } else {
            jQuery('.content-filter-options').hide();
        }
    });

    jQuery('#rssap-dont-add-excerpt').change(function() {
        if (jQuery(this).is(':checked')) {
            jQuery('#rssap-limit-excerpt-block').hide();
        } else {
            jQuery('#rssap-limit-excerpt-block').show();
        }
    });

    jQuery('#rssap-add-more-tag').change(function() {
        if (jQuery(this).is(':checked')) {
            jQuery('#rssap-add-more-tag-block').show();
        } else {
            jQuery('#rssap-add-more-tag-block').hide();
        }
    });

    jQuery('input[name=thumbnail]').change(function() {
        if (jQuery('#featured-upload-option').is(':checked')) {
            jQuery('#featured-upload-block').show();
        } else {
            jQuery('#featured-upload-block').hide();
        }
    });


    // Uploading files
    var fallbackFrames = { image: false };
    var featuredFrames = { image: false };

    jQuery('#featured-upload-block .rss-upload').on('click', function( event ){
        var targetField = jQuery( this ).data( 'target-field' );
        var targetHiddenField = jQuery( this ).data( 'target-hidden-field' );
        var targetType = jQuery( this ).data( 'type' );

        event.preventDefault();

        // If the media frame already exists, reopen it.
        if ( featuredFrames[targetType] ) {
            // Set the post ID to what we want
            featuredFrames[targetType].open();
            return;
        }

        // Create the media frame.
        featuredFrames[targetType] = wp.media.frames.file_frame = wp.media({
            title: jQuery( this ).data( 'dialog-title' ),
            button: {
                text: jQuery( this ).data( 'button-text' ),
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });

        // When an image is selected, run a callback.
        featuredFrames[targetType].on( 'select', function() {
            // We set multiple to false so only get one image from the uploader
            attachment = featuredFrames[targetType].state().get('selection').first().toJSON();

            // Do something with attachment.id and/or attachment.url here
            jQuery("#"+targetField).val(attachment.url).blur();
            jQuery('#'+targetHiddenField).val(attachment.id);
        });

        // Finally, open the modal
        featuredFrames[targetType].open();
    });

    jQuery('#fallback-upload-block .rss-upload').on('click', function( event ){
        var targetField = jQuery( this ).data( 'target-field' );
        var targetHiddenField = jQuery( this ).data( 'target-hidden-field' );
        var targetType = jQuery( this ).data( 'type' );

        event.preventDefault();

        // If the media frame already exists, reopen it.
        if ( fallbackFrames[targetType] ) {
            // Set the post ID to what we want
            fallbackFrames[targetType].open();
            return;
        }

        // Create the media frame.
        fallbackFrames[targetType] = wp.media.frames.file_frame = wp.media({
            title: jQuery( this ).data( 'dialog-title' ),
            button: {
                text: jQuery( this ).data( 'button-text' ),
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });

        // When an image is selected, run a callback.
        fallbackFrames[targetType].on( 'select', function() {
            // We set multiple to false so only get one image from the uploader
            attachment = fallbackFrames[targetType].state().get('selection').first().toJSON();

            // Do something with attachment.id and/or attachment.url here
            jQuery("#"+targetField).val(attachment.url).blur();
            jQuery('#'+targetHiddenField).val(attachment.id);
        });

        // Finally, open the modal
        fallbackFrames[targetType].open();
    });


    jQuery('#rssap-enable-scrapper').change();
    jQuery('#rssap-enable-filters').change();
    jQuery('#rssap-dont-add-excerpt').change();
    jQuery('#rssap-add-more-tag').change();

    if (jQuery('#featured-upload-option').is(':checked')) {
        jQuery('#featured-upload-block').show();
    } else {
        jQuery('#featured-upload-block').hide();
    }
});

function changeExtractorRule(xpath)
{
    jQuery('#content-extractor-rule').val(xpath);
}

function changeExtractorIgnoreRule(xpath)
{
    jQuery('#content-extractor-ignore-rule').val(xpath);
}